/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import java.util.ArrayList;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.RendererCache;
import net.optifine.util.Either;

public abstract class ModelAdapter {
    private Either<blz, dgx> type;
    private String name;
    private float shadowSize;
    private String[] aliases;

    public ModelAdapter(blz entityType, String name, float shadowSize) {
        this(Either.makeLeft((Object)entityType), name, shadowSize, null);
    }

    public ModelAdapter(blz entityType, String name, float shadowSize, String[] aliases) {
        this(Either.makeLeft((Object)entityType), name, shadowSize, aliases);
    }

    public ModelAdapter(dgx tileEntityType, String name, float shadowSize) {
        this(Either.makeRight((Object)tileEntityType), name, shadowSize, null);
    }

    public ModelAdapter(dgx tileEntityType, String name, float shadowSize, String[] aliases) {
        this(Either.makeRight((Object)tileEntityType), name, shadowSize, aliases);
    }

    public ModelAdapter(Either<blz, dgx> type, String name, float shadowSize, String[] aliases) {
        this.type = type;
        this.name = name;
        this.shadowSize = shadowSize;
        this.aliases = aliases;
    }

    public Either<blz, dgx> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public float getShadowSize() {
        return this.shadowSize;
    }

    public abstract fkt makeModel();

    public abstract fmx getModelRenderer(fkt var1, String var2);

    public abstract String[] getModelRendererNames();

    public abstract IEntityRenderer makeEntityRender(fkt var1, float var2, RendererCache var3, int var4);

    public boolean setTextureLocation(IEntityRenderer er, ahg textureLocation) {
        return false;
    }

    public fmx[] getModelRenderers(fkt model) {
        String[] names = this.getModelRendererNames();
        ArrayList<fmx> list = new ArrayList<fmx>();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            fmx mr = this.getModelRenderer(model, name);
            if (mr == null) continue;
            list.add(mr);
        }
        fmx[] mrs = list.toArray(new fmx[list.size()]);
        return mrs;
    }

    public static fmx bakeModelLayer(fmv loc) {
        return evi.O().ao().getContext().a(loc);
    }
}

