/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.Set;
import net.optifine.Config;

public class ChunkVisibility {
    public static final int MASK_FACINGS = 63;
    public static final ic[][] enumFacingArrays = ChunkVisibility.makeEnumFacingArrays((boolean)false);
    public static final ic[][] enumFacingOppositeArrays = ChunkVisibility.makeEnumFacingArrays((boolean)true);
    private static int counter = 0;
    private static int iMaxStatic = -1;
    private static int iMaxStaticFinal = 16;
    private static fns worldLast = null;
    private static int pcxLast = Integer.MIN_VALUE;
    private static int pczLast = Integer.MIN_VALUE;

    public static int getMaxChunkY(fns world, blv viewEntity, int renderDistanceChunks, fty viewFrustum) {
        int minHeight = world.J_();
        int maxHeight = world.K_();
        int minChunkHeight = minHeight >> 4;
        int pcx = auo.a((double)viewEntity.dr()) >> 4;
        int pcy = auo.a((double)(viewEntity.dt() - (double)minHeight)) >> 4;
        int pcz = auo.a((double)viewEntity.dx()) >> 4;
        int pcyMax = maxHeight - minHeight >> 4;
        pcy = Config.limit((int)pcy, (int)0, (int)(pcyMax - 1));
        long playerSectionKey = iz.c((hx)viewEntity.dm());
        dnc playerSection = world.getSectionStorage().d(playerSectionKey);
        boolean multiplayer = !Config.isIntegratedServerRunning();
        int cxStart = pcx - renderDistanceChunks;
        int cxEnd = pcx + renderDistanceChunks;
        int czStart = pcz - renderDistanceChunks;
        int czEnd = pcz + renderDistanceChunks;
        if (world != worldLast || pcx != pcxLast || pcz != pczLast) {
            counter = 0;
            iMaxStaticFinal = 16;
            worldLast = world;
            pcxLast = pcx;
            pczLast = pcz;
        }
        if (counter == 0) {
            iMaxStatic = -1;
        }
        int iMax = iMaxStatic;
        switch (counter) {
            case 0: {
                cxEnd = pcx;
                czEnd = pcz;
                break;
            }
            case 1: {
                cxStart = pcx;
                czEnd = pcz;
                break;
            }
            case 2: {
                cxEnd = pcx;
                czStart = pcz;
                break;
            }
            case 3: {
                cxStart = pcx;
                czStart = pcz;
            }
        }
        for (int cx = cxStart; cx < cxEnd; ++cx) {
            for (int cz = czStart; cz < czEnd; ++cz) {
                dlo chunk = world.d(cx, cz);
                if (chunk.C()) {
                    int i;
                    if (!multiplayer || (i = viewFrustum.getHighestUsedChunkIndex(cx, iMax, cz)) <= iMax) continue;
                    iMax = i;
                    continue;
                }
                dlp[] ebss = chunk.d();
                for (int i = ebss.length - 1; i > iMax; --i) {
                    dlp ebs = ebss[i];
                    if (ebs == null || ebs.c()) continue;
                    if (i <= iMax) break;
                    iMax = i;
                    break;
                }
                try {
                    Map mapTileEntities = chunk.G();
                    if (mapTileEntities.isEmpty()) continue;
                    Set keys = mapTileEntities.keySet();
                    for (hx pos : keys) {
                        int i = pos.v() - minHeight >> 4;
                        if (i <= iMax) continue;
                        iMax = i;
                    }
                    continue;
                }
                catch (ConcurrentModificationException mapTileEntities) {
                    // empty catch block
                }
            }
        }
        if (counter == 0) {
            LongSet sectionKeys = world.getSectionStorage().getSectionKeys();
            LongIterator it2 = sectionKeys.iterator();
            while (it2.hasNext()) {
                long sectionKey = it2.nextLong();
                int sectionY = iz.c((long)sectionKey);
                int i = sectionY - minChunkHeight;
                if (sectionKey == playerSectionKey && i == pcy && playerSection != null && playerSection.getEntityList().size() == 1 || i <= iMax) continue;
                iMax = i;
            }
        }
        if (counter < 3) {
            iMaxStatic = iMax;
            iMax = iMaxStaticFinal;
        } else {
            iMaxStaticFinal = iMax;
            iMaxStatic = -1;
        }
        counter = (counter + 1) % 4;
        return (iMax << 4) + minHeight;
    }

    public static boolean isFinished() {
        return counter == 0;
    }

    private static ic[][] makeEnumFacingArrays(boolean opposite) {
        int count = 64;
        ic[][] arrs = new ic[count][];
        for (int i = 0; i < count; ++i) {
            ArrayList<ic> list = new ArrayList<ic>();
            for (int ix = 0; ix < ic.p.length; ++ix) {
                ic facing = ic.p[ix];
                ic facingMask = opposite ? facing.g() : facing;
                int mask = 1 << facingMask.ordinal();
                if ((i & mask) == 0) continue;
                list.add(facing);
            }
            ic[] fs = list.toArray(new ic[list.size()]);
            arrs[i] = fs;
        }
        return arrs;
    }

    public static ic[] getFacingsNotOpposite(int setDisabled) {
        int index = ~setDisabled & 0x3F;
        return enumFacingOppositeArrays[index];
    }

    public static ic[] getFacings(int setDirections) {
        int index = setDirections & 0x3F;
        return enumFacingArrays[index];
    }

    public static void reset() {
        worldLast = null;
    }
}

