/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashSet;
import java.util.Set;
import net.optifine.Config;
import net.optifine.DynamicLights;

public class DynamicLight {
    private blv entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private long timeCheckMs = 0L;
    private Set<hx> setLitChunkPos = new HashSet();
    private hx.a blockPosMutable = new hx.a();

    public DynamicLight(blv entity) {
        this.entity = entity;
        this.offsetY = entity.cI();
    }

    public void update(ftf renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.dr() - 0.5;
        double posY = this.entity.dt() - 0.5 + this.offsetY;
        double posZ = this.entity.dx() - 0.5;
        int lightLevel = DynamicLights.getLightLevel((blv)this.entity);
        double dx = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (Math.abs(dx) <= delta && Math.abs(dy) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        HashSet setNewPos = new HashSet();
        if (lightLevel > 0) {
            ic dirX = (auo.a((double)posX) & 0xF) >= 8 ? ic.f : ic.e;
            ic dirY = (auo.a((double)posY) & 0xF) >= 8 ? ic.b : ic.a;
            ic dirZ = (auo.a((double)posZ) & 0xF) >= 8 ? ic.d : ic.c;
            hx chunkPos = hx.a((double)posX, (double)posY, (double)posZ);
            fwg.b chunk = renderGlobal.getRenderChunk(chunkPos);
            hx chunkPosX = this.getChunkPos(chunk, chunkPos, dirX);
            fwg.b chunkX = renderGlobal.getRenderChunk(chunkPosX);
            hx chunkPosZ = this.getChunkPos(chunk, chunkPos, dirZ);
            fwg.b chunkZ = renderGlobal.getRenderChunk(chunkPosZ);
            hx chunkPosXZ = this.getChunkPos(chunkX, chunkPosX, dirZ);
            fwg.b chunkXZ = renderGlobal.getRenderChunk(chunkPosXZ);
            hx chunkPosY = this.getChunkPos(chunk, chunkPos, dirY);
            fwg.b chunkY = renderGlobal.getRenderChunk(chunkPosY);
            hx chunkPosYX = this.getChunkPos(chunkY, chunkPosY, dirX);
            fwg.b chunkYX = renderGlobal.getRenderChunk(chunkPosYX);
            hx chunkPosYZ = this.getChunkPos(chunkY, chunkPosY, dirZ);
            fwg.b chunkYZ = renderGlobal.getRenderChunk(chunkPosYZ);
            hx chunkPosYXZ = this.getChunkPos(chunkYX, chunkPosYX, dirZ);
            fwg.b chunkYXZ = renderGlobal.getRenderChunk(chunkPosYXZ);
            this.updateChunkLight(chunk, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYXZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    private hx getChunkPos(fwg.b renderChunk, hx pos, ic facing) {
        if (renderChunk != null) {
            return renderChunk.a(facing);
        }
        return pos.a(facing, 16);
    }

    private void updateChunkLight(fwg.b renderChunk, Set<hx> setPrevPos, Set<hx> setNewPos) {
        if (renderChunk == null) {
            return;
        }
        fwg.a compiledChunk = renderChunk.d();
        if (compiledChunk != null && !compiledChunk.a()) {
            renderChunk.a(false);
            renderChunk.setNeedsBackgroundPriorityUpdate(true);
        }
        hx pos = renderChunk.f().i();
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    public void updateLitChunks(ftf renderGlobal) {
        for (hx posOld : this.setLitChunkPos) {
            fwg.b chunkOld = renderGlobal.getRenderChunk(posOld);
            this.updateChunkLight(chunkOld, null, null);
        }
    }

    public blv getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + this.entity + ", offsetY: " + this.offsetY;
    }
}

